using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using Verse;
using Verse.Sound;


namespace Verse.AI{
public class JobDriver_Equip : JobDriver
{
	protected override IEnumerable<Toil> MakeNewToils()
	{
		yield return Toils_Reserve.Reserve( TargetIndex.A );

		//Goto equipment
		{
			Toil gotoEquipment = new Toil();
			gotoEquipment.initAction = ()=>
			{
				//Should this not reserve?

				pawn.pather.StartPath(TargetThingA, PathEndMode.ClosestTouch);
			};
			gotoEquipment.defaultCompleteMode = ToilCompleteMode.PatherArrival;
			gotoEquipment.FailOnDespawnedNullOrForbidden(TargetIndex.A);
			yield return gotoEquipment;
		}
		
		//Take equipment
		{
			Toil takeEquipment = new Toil();
			takeEquipment.initAction = ()=>
			{
				ThingWithComps eq = ((ThingWithComps)CurJob.targetA.Thing);

				ThingWithComps toEquip = null;
				bool remove = false;
        
				if(eq.def.stackLimit > 1 && eq.stackCount > 1)
					toEquip = (ThingWithComps)eq.SplitOff(1);
				else
				{
					toEquip = eq;
					remove = true;
				}
        
				pawn.equipment.MakeRoomFor( toEquip );	
				pawn.equipment.AddEquipment( toEquip );	
		
				if( eq.def.soundInteract != null )
					eq.def.soundInteract.PlayOneShot(new TargetInfo(pawn.Position, pawn.Map));
        
				if(remove)
					eq.DeSpawn();
			};
			takeEquipment.defaultCompleteMode = ToilCompleteMode.Instant;
			yield return takeEquipment;
		}
	}
}}











